/////////////////////////////////////////////////////////////////////////////////

// Original obtained from ShaderToy.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Use defines here rather than edit the body of the code.

#define iGlobalTime u_Elapsed
#define iResolution u_WindowSize
#define iMouse AUTO_MOUSE

/////////////////////////////////////////////////////////////////////////////////

// Simple "Automatic Mouse". Simulates scanning the mouse over the full range of
// the screen with the X and Y scanning frequencies being different. TheEmu.

#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
#define MOUSE_POS   vec2((1.0+cos(iGlobalTime*MOUSE_SPEED))*u_WindowSize/2.0)
#define MOUSE_PRESS vec2(0.0,0.0)
#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )

/////////////////////////////////////////////////////////////////////////////////

// The ShaderToy shaders often use textures as inputs named iChannel0. With VGHD
// this may access a Sprite, ClipSprite or ClipNameSprite image depending on how
// the .scn file declares them.
//
// Note, the name used here does not seem to make any difference, so I have used
// iChannel0 which is what is used by ShaderToy but you can use any name as long
// as it matches the use in the main body of the shader. TheEmu.

uniform sampler2D iChannel0;

// With VGHD the range of the P argument's components of the texture functions is
// 0.0 to 1.0 whereas with ShaderToy it seems that the upper limits are given  by
// the number of pixels in each direction, typically 512 or 64.  We therefore use
// the following functions instead.

vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}

// Rather than edit the body of the original shader we use use a define  here  to
// redirect texture calls to the above functions.

#define texture2D texture2D_Fract

/////////////////////////////////////////////////////////////////////////////////

// by maq/floppy
vec3 flower(vec2 p, float m)
{
   	vec3 col=vec3(0.0);
   	p -= vec2(1.5-0.2*sin(iGlobalTime*m),1.5);
   	float r = sqrt(dot(p,p));
   	float f=1.1;
   	float listki=5.0;
  	float at = atan(p.y/p.x);
   	float phi =  at+(sin(iGlobalTime*m)-sin(iGlobalTime*m+0.4)*sin(r));
	float phi2 = at+sin(iGlobalTime*m*1.0+0.3)-sin(iGlobalTime*m*1.0+0.6)*sin(r);

  	if(r<exp(r*2.6)*0.1+(0.01+abs(sin(listki*phi)))) 
      f=r;           
   	else
      col = mix( vec3(0.9,0.9,0.9), vec3(0.9,0.7,0.7),f) ;

   	if(r<0.1+abs(sin(listki*phi2+(1.0+sin(iGlobalTime))*0.5)))
   	{   
   	  f = r; 
      col = mix( vec3(0.97+0.0025*m,0.97+0.0025*m,0), vec3(1,1,1), 10.0*f) ;
   	}
   	return col;
}

void main(void)
{
	vec2 p = 1.4*gl_FragCoord.xy / iResolution.xy;
	p.y*=0.8;
	p.x-=0.1;
	vec2 cp=p-vec2(1.1,0.5);
	vec3 col = 0.01*vec3(0.2/dot(cp,cp),0.2/dot(cp,cp),0.1/dot(cp,cp));
   	col += flower((p.xy+vec2(0,0))*4.2,2.5);   
   	col += flower((p.xy+vec2(-0.45,-0.4))*4.5,3.2);   
   	col += flower((p.xy+vec2(0.13,-0.4))*4.1,3.0);   
   	col += flower((p.xy+vec2(-0.6,-0.1))*8.2,3.1);   
	gl_FragColor = vec4(col,1.0);	
}